% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_sim_cr_cs.R
\name{DAISIE_sim_cr_cs}
\alias{DAISIE_sim_cr_cs}
\title{Simulates island replicates with an clade-specific (CS) diversity-dependent
constant-rate process}
\usage{
DAISIE_sim_cr_cs(
  total_time,
  M,
  pars,
  replicates,
  nonoceanic_pars,
  prop_type2_pool,
  replicates_apply_type2,
  sample_freq,
  hyper_pars,
  area_pars,
  cond,
  verbose
)
}
\arguments{
\item{total_time}{Numeric defining the length of the simulation in time
units.}

\item{M}{Numeric defining the size of mainland pool, i.e. the number of
species that can potentially colonize the island.}

\item{pars}{A numeric vector containing the model parameters:
\itemize{
  \item{\code{pars[1]}: lambda^c (cladogenesis rate)}
  \item{\code{pars[2]}: mu (extinction rate)}
  \item{\code{pars[3]}: K (carrying capacity), set K=Inf for diversity
  independence.}
  \item{\code{pars[4]}: gamma (immigration rate)}
  \item{\code{pars[5]}: lambda^a (anagenesis rate)}
  \item{\code{pars[6]}: lambda^c (cladogenesis rate) for either type 2 species
  or rate set 2 in rate shift model}
  \item{\code{pars[7]}: mu (extinction rate) for either type 2 species or rate
  set 2 in rate shift model}
  \item{\code{pars[8]}: K (carrying capacity) for either type 2 species or rate
  set 2 in rate shift model, set K=Inf for diversity independence.}
  \item{\code{pars[9]}: gamma (immigration rate) for either type 2 species
  or rate set 2 in rate shift model}
  \item{\code{pars[10]}: lambda^a (anagenesis rate) for either type 2
  species or rate set 2 in rate shift model}
}
Elements 6:10 are required only when type 2 species are included
or in the rate shift model. For \code{\link{DAISIE_sim_relaxed_rate}()}
\code{pars[6]} is the standard deviation of the gamma distribution for the
relaxed parameter and the parameter chosen by the \code{relaxed_par}
argument is the mean of the gamma distribution for the relaxed parameter.}

\item{replicates}{Integer specifying number of island replicates to be
simulated.}

\item{nonoceanic_pars}{A vector of length two with:
\itemize{
  \item{[1]: the probability of sampling a species from the mainland}
  \item{[2]: the probability of the species sampled from the mainland
  being nonendemic}
}}

\item{prop_type2_pool}{Fraction of mainland species that belongs to the
second subset of species (type 2). Applies only when two types of species
are simulated (length(pars) = 10). For \code{\link{DAISIE_dataprep}()}
applies only if number_clade_types = 2.  In \code{\link{DAISIE_dataprep}()}
the default \code{"proportional"} sets the fraction to be proportional to
the number of clades of distinct macroevolutionary process that have
colonised the island.}

\item{replicates_apply_type2}{Applies only when two types of species are
being simulated. Default replicates_apply_type2 = TRUE runs simulations
until the number of islands where a type 2 species has colonised is equal
to the specified number of replicates. This is recommended if
\code{prop_type2_pool} is small or if the rate of immigration of type two
species (\code{pars[9]}) is low, meaning that more replicates are needed to
achieved an adequate sample size of islands with type 2 species. Setting
\code{replicates_apply_type2 = FALSE} simulates islands up to the
specified number of replicates regardless of whether type 2 species have
colonised or not.}

\item{sample_freq}{Numeric specifing the number of units times should be
divided by for plotting purposes. Larger values will lead to plots with
higher resolution, but will also run slower.}

\item{hyper_pars}{A named list of numeric hyperparameters for the rate
calculations as returned by \code{\link{create_hyper_pars}()}:
\itemize{
  \item{[1]: is d the scaling parameter for exponent for calculating
  cladogenesis rate}
  \item{[2]: is x the exponent for calculating extinction rate}
}}

\item{area_pars}{A named list containing area and sea level parameters as
created by \code{\link{create_area_pars}()}:
\itemize{
  \item{[1]: maximum area}
  \item{[2]: current area}
  \item{[3]: value from 0 to 1 indicating where in the island's history the
  peak area is achieved}
  \item{[4]: total island age}
  \item{[5]: amplitude of area fluctuation from sea level}
  \item{[6]: frequency of sine wave of area change from sea level}
  \item{[7]: angle of the slope of the island}
}}

\item{cond}{cond = 0 : conditioning on island age \cr cond = 1 :
conditioning on island age and non-extinction of the island biota \cr.
cond > 1 : conditioning on island age and having at least cond colonizations
on the island. This last option is not yet available for the IW model \cr}

\item{verbose}{A numeric vector of length 1, which in simulations and
`DAISIEdataprep()` can be `1` or `0`, where `1` gives intermediate output
should be printed.
For ML functions a numeric determining if intermediate output should be
printed. The default: `0` does not print, `1` prints the initial
likelihood and the settings that were selected (which parameters are
to be optimised, fixed or shifted), `2` prints the same as `1 and also the
intermediate output of the parameters and loglikelihood, while `3` the
same as `2` and prints intermediate progress during likelihood computation.}
}
\value{
A list. The highest level of the least corresponds to each individual
replicate. See return for `DAISIE_sim_cr()` for details.
}
\description{
Simulates island replicates with an clade-specific (CS) diversity-dependent
constant-rate process
}
