\name{book.stack}
\alias{book.stack}

\title{
Book Stack Test
}

\description{
Performs Book Stack test of Ryabko and Monarev (2005) to evaluate the randomness of an RNG. The Chi-Square test is applied as the goodness-of-fit test. 
}

\usage{
book.stack(A, B, k=2, alpha=0.05, bit=FALSE)
}

\arguments{
  \item{A}{
      a vector or matrix that includes random data. See details for further information.
}
  \item{B}{
      the length of words (B-bit) that the chippered file will be divided.
}
  \item{k}{
      the number of subsets that the alphabet will be divided. It should be chosen to ensure \eqn{|A|/k} will be an integer.
}
  \item{alpha }{
      a predetermined value of type-I error with the default value of 0.05.
}
\item{bit}{
      if \code{A} contains a sequence of bits, \code{bit} is set \code{TRUE}. Otherwise, a sequence of integers is entered and \code{bit} is set \code{FALSE}.
}
}
\details{
  If \code{A} contains a sequence of bits, then \code{A} should be a matrix of \eqn{B}x\eqn{N}, where \eqn{N} is the number of words (integers) generated by the RNG of interest. Otherwise, \code{A} is an \eqn{N}x\eqn{1} vector of the words. Because bits will be converted to base-10 before application of the test, implementation time will be shorter with integer input. 
  Optimal value of \eqn{N}, which also represents the length of sample that is composed of B-bit words, is obtained by the optimal length of sample composed of bits (\eqn{n}) that is given by Ryabko and Monarev (2005) as \eqn{n=B(2^(B/2))}. For example, if \eqn{B=16}, then \eqn{n=4096} and the legth of alphabet is 65536. In this case, we need to enter 4096 bits or \eqn{N=4096/16=256} integers. However, under the setting \eqn{B=32}, the length of alphabet is 2^32 and we need to enter 65536. Note that it is hard to implement the test under the latter setting due to the memory overflows. Therefore, this test is applicable for smaller values of \eqn{B} than 32-bits.  
  In this test, because there is no asymptotic theoretical distribution introduced, only chi-square test is applied as goodness-of-fit test. 
}
\value{
\item{statistic }{
     calculated value of the test statistic.
}
\item{p.value }{
     p-value of the Chi-Square test.
}
\item{BS.result }{
    returns 0 if H0 is rejected and 1 otherwise.
}
}
\references{
Ryabko, B.Ya., Monarev, V.A., Using information theory approach to randomness testing. Journal of Statistical Planning and Inference (2005), 133, 95--110.
}
\author{
Haydar Demirhan

Maintainer: Haydar Demirhan <haydarde@hacettepe.edu.tr>
}

\examples{

RNGkind(kind = "L'Ecuyer-CMRG")
B=8                 # Bit length is 8. 
n=B*(2^(B/2))       # Number of required bits.
N=n/B               # Number of integers to be generated.
A=round(runif(N,0,(2^B-1)))
k=2                   # Divide alphabet to two sub-sets.
alpha=0.05
test=book.stack(A, B, k, alpha, bit = FALSE)
print(test)

}

\keyword{Chi-Square }
\keyword{nonparametric }
\keyword{goodness-of-fit test }
\keyword{randomness test }