% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossGEE.R
\name{CrossGEE}
\alias{CrossGEE}
\title{Run a GEE model for data from a crossover experiment}
\usage{
CrossGEE(
  response,
  period,
  treatment,
  id,
  carry,
  covar = NULL,
  data,
  family = gaussian(),
  correlation = "independence",
  formula = NULL
)
}
\arguments{
\item{response}{A character string specifying the name of the response variable of the crossover
experimental design}

\item{period}{A character string specifying the name of vector with the
observation period of the responses of  the crossover experimental design}

\item{treatment}{A character string specifying the name of vector with the
treatment applied at each observation of the crossover experimental design}

\item{id}{A  character string specifying the name of vector which identifies
the experimental units. The length of ‘id’
 should be the same as the number of observations. Data are assumed to be sorted so
  that observations on each cluster appear as contiguous rows in data. If data
  is not sorted this way, the function will not identify the clusters correctly.
  If data is not sorted this way, a warning will be issued.}

\item{carry}{A vector of  character string specifying the name set of dummy
 variables that indicates the treatment applied
in the previous period of each experimental unit. They must be 0 in period 1}

\item{covar}{A vector of  character string specifying the name of possible
covariates of the crossover experimental design}

\item{data}{A data frame with all the variables of the crossover experimental design}

\item{family}{See corresponding documentation to \code{glm}}

\item{correlation}{a character string specifying the correlation structure.
The following are permitted: "independence", "exchangeable", "ar1" and
"unstructured"}

\item{formula}{A formula related the response variable with the explanatory
variables. If it is \code{NULL}, formula
\code{response~period+treatment+carry+covar} will be evaluated}
}
\value{
\code{QIC} The QIC of the models: The model are fitted by \code{geeglm}

\code{model} The model fitted by \code{geeglm}.
}
\description{
Provides a GEE model for the data of a crossover design with S
sequences of T periods. There must be one observation of each
experimental unit in each period.
}
\examples{
data(Water)
model <- CrossGEE(response="LCC", covar=c("Age"), period="Period",
                  treatment = "Treatment", id="ID", carry="Carry_Agua",
                  family=gaussian(),correlation ="ar1" ,data=Water)

model$QIC
model$model

summary(model$model)
}
