% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbtv.R
\name{sbtv}
\alias{sbtv}
\title{Scenario Barrier Time-Varying Volatility AT1P model}
\usage{
sbtv(V0, H, p, B, sigma, r, t)
}
\arguments{
\item{V0}{firm value at time \code{t = 0} (it is a constant value).}

\item{H}{vector of differents safety level at time \code{t = 0}.}

\item{p}{vector of the probability of different scenario (sum of p must be 1).}

\item{B}{free positive parameter used for shaping the barrier \code{Ht}.}

\item{sigma}{a vector of constant stepwise volatility \eqn{\sigma_t}.}

\item{r}{a vector of constant stepwise risk-free rate.}

\item{t}{a vector of debt maturity structure (it is a numeric vector).}
}
\value{
\code{sbtv} returns an object of class \code{data.frame} containing the survival probability
for each maturity. The last column is the default intensity calculated
among each interval \eqn{\Delta t}.
}
\description{
\code{sbtv} calculates the survival probability \eqn{Q(\tau > t)} and default intensity
for each maturity according to the structural SBTV model.
}
\details{
\code{sbtv} is an extension of the \code{at1p} model. In this model the parameter \code{H0} used
in the \code{at1p} model is replaced by a random variable assuming different values in different
scenarios, each scenario with a different probability. The survival probability is calculated
as a weighted avarage of the survival probability using the formula:
\deqn{SBTV.Surv = \sum_{i = 1}^N p[i] * AT1P.Surv(H[i])}
where \code{AT1P.Surv(H[i])} is the survival probability computed according to the AT1P model
when \eqn{H_0 = H[i]} and with weights equal to the probabilities of the different scenarios.
}
\examples{
mod <- sbtv(V0 = 1, H = c(0.4, 0.8), p = c(0.95, 0.05), B = 0, sigma = rep(0.20, 10),
            r = cdsdata$ED.Zero.Curve, t = cdsdata$Maturity)
mod

plot(cdsdata$Maturity, mod$Survival, type = 'b')

}
\references{
Damiano Brigo, Massimo Morini, Andrea Pallavicini (2013)
Counterparty Credit Risk, Collateral and Funding.
With Pricing Cases for All Asset Classes.
}
