\name{predict.CoxBoost}
\alias{predict.CoxBoost}
\title{Predict method for CoxBoost fits}
\description{
Obtains predictions at specified boosting steps from a CoxBoost object fitted by \code{\link{CoxBoost}}.  
}
\usage{
\method{predict}{CoxBoost}(object,newdata=NULL,newtime=NULL,newstatus=NULL,
        at.step=NULL,times=NULL,type=c("lp","logplik","risk"),\ldots)
}
\arguments{
\item{object}{fitted CoxBoost object from a \code{\link{CoxBoost}} call.}
\item{newdata}{\code{n.new * p} matrix with new covariate values. If just prediction for the training data is wanted, it can be omitted.}
\item{newtime, newstatus}{vectors with observed time and censoring indicator (0 for censoring, 1 for no censoring) for new observations, where prediction is wanted. Only required if predicted partial log-likelihood is wanted, i.e., if \code{type="logplik"}. This can also be omitted when prediction is only wanted for the training data, i.e., \code{newdata=NULL}.}
\item{at.step}{scalar or vector of boosting step(s) at which prediction is wanted. If \code{type="risk"} is used, only one step is admissible. If no step is given, the final boosting step is used.}
\item{times}{vector with \code{T} time points where prediction is wanted. Only needed for \code{type="risk"}}
\item{type}{type of prediction to be returned: \code{"lp"} gives the linear predictor, \code{"logplik"} the partial log-likelihood, and \code{"risk"} the predicted probability of still being event-free at the time points given in \code{times}.}
\item{\dots}{miscellaneous arguments, none of which is used at the moment.}
}
\value{
For \code{type="lp"} and \code{type="logplik"} a vector of length \code{n.new} (\code{at.step} being a scalar) or a \code{n.new * length(at.step)} matrix (\code{at.step} being a vector) with predictions is returned.  
For \code{type="risk"} a \code{n.new * T} matrix with predicted probabilities at the specific time points is returned.  
}
\author{
Harald Binder \email{binderh@fdm.uni-freiburg.de}
}
\examples{
#   Generate some survival data with 10 informative covariates 
n <- 200; p <- 100
beta <- c(rep(1,10),rep(0,p-10))
x <- matrix(rnorm(n*p),n,p)
real.time <- -(log(runif(n)))/(10*exp(drop(x \%*\% beta)))
cens.time <- rexp(n,rate=1/10)
status <- ifelse(real.time <= cens.time,1,0)
obs.time <- ifelse(real.time <= cens.time,real.time,cens.time)

#   define training and test set

train.index <- 1:100
test.index <- 101:200

#   Fit CoxBoost to the training data

cbfit <- CoxBoost(time=obs.time[train.index],status=status[train.index],
                  x=x[train.index,],stepno=300,penalty=100) 

#   mean partial log-likelihood for test set in every boosting step

step.logplik <- predict(cbfit,newdata=x[test.index,],
                        newtime=obs.time[test.index],
                        newstatus=status[test.index],
                        at.step=1:300,type="logplik")

plot(step.logplik)

#   names of covariates with non-zero coefficients at boosting step
#   with maximal test set partial log-likelihood

print(cbfit$xnames[cbfit$coefficients[which.max(step.logplik),] != 0])


}
\keyword{models} \keyword{regression} \keyword{survial}
