% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_event}
\alias{get_event}
\title{Access CoronaNet Event Data API}
\usage{
get_event(
  countries = "All",
  type = "All",
  type_sub_cat = "All",
  default_columns = c("record_id", "policy_id", "entry_type", "update_type",
    "update_level", "update_level_var", "date_announced", "date_start", "date_end",
    "date_end_spec", "country", "init_country_level", "province", "target_init_same",
    "target_country", "target_province", "target_city", "target_intl_org",
    "target_other", "target_who_what", "target_who_gen", "target_direction",
    "compliance", "enforcer", "city", "type", "type_sub_cat", "description"),
  additional_columns = NULL,
  from = "2019-12-31",
  to = "2022-01-01",
  include_no_end_date = TRUE,
  time_out = FALSE
)
}
\arguments{
\item{countries}{A character vector of country name(s), e.g., c("Yemen", "Saudi Arabia"). "All" is used as the default.}

\item{type}{A character vector of policy types, e.g., c("Lockdown", "Curfew"). "All" is used as the default. See https://www.coronanet-project.org/taxonomy.html? for a list of policy types.}

\item{type_sub_cat}{A character vector of policy types, e.g., c("Self-testing", "Drive-in testing centers"). "All" is used as the default. See https://www.coronanet-project.org/taxonomy.html? for a list of policy subtypes and their related policy types.}

\item{default_columns}{A character vector specifying the minimum set of columns of data to retrieve. Defaults to record/policy ID, dates,
policy targets, policy type and sub-type, and description}

\item{additional_columns}{By default NULL. Select additional columns to include with the query.}

\item{from}{A character vector for the earliest start date, e.g., "2019-12-31".}

\item{to}{A character vector for the last end date, e.g., "2019-06-01".}

\item{include_no_end_date}{TRUE/FALSE - whether to include policy records that do not yet have an end date.
By default set to TRUE (this is a lot of records).}

\item{time_out}{Whether to set a 5-second time-out on the API call. Beyond 5 seconds, the function
will return an empty data-frame. Only useful for complying with CRAN
submission requirements. Default is FALSE.}
}
\value{
A dataframe with one record per COVID-19 policy
}
\description{
Use this function to obtain the latest policy event data from CoronaNet via an http API.
}
\details{
This function offers programmatic access to the CoronaNet public release dataset, comprising
over 80,000 distinct policy records and 93 fields. The dataset is updated regularly as policy
coding continues. The entire dataset can be downloaded through this function, although by default
it selects a subset of columns (see argument details below). To access additional columns, use the
\code{additional_columns} argument and include a character vector of column names. For a full list of
possible columns, see the \href{https://www.coronanet-project.org/assets/CoronaNet_Codebook_Panel.pdf}{CoronaNet codebook}.

For more information about the data creation, see \href{https://www.nature.com/articles/s41562-020-0909-7}{our paper}.

Citation:

Cheng, Cindy; Barcelo, Joan; Spencer Hartnett, Allison; Kubinec, Robert and Messerschmidt, Luca. "COVID-19 Government Response Event Dataset (CoronaNet v1.0)." \strong{Nature Human Behavior} 4, pp. 756-768 (2020).

See code examples for demonstration of filtering syntax.
}
\examples{
# Grab all data for Saudi Arabia from first 4 months of pandemic

saudi_data <- get_event(countries = "Saudi Arabia", type = "All",
type_sub_cat = "All", from = "2019-12-31", to = "2020-04-30")

# Each row is one policy record
saudi_data

# Use the additional_columns argument to add additional columns
# beyond the default set
# In this case, we'll add the link column to get the URLs
# for underlying public sources
saudi_data_links <- get_event(countries = "Saudi Arabia", type = "All",
                              type_sub_cat = "All",
                              from = "2019-12-31", to = "2020-04-30",
                              additional_columns = "link")

head(saudi_data_links$link)

# look at a specific policy type

saudi_data_subcat <- get_event(countries = "Saudi Arabia",
                               type = "Lockdown",
                               type_sub_cat = "All",
                               from = "2019-12-31", to = "2020-04-30")

head(saudi_data_subcat$description)
}
