% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWC.R
\name{gwc}
\alias{gwc}
\title{Calculate the gwc score between two vectors, using either a weighted spearman or pearson correlation}
\usage{
gwc(x1, p1, x2, p2, method.cor = c("pearson", "spearman"),
  nperm = 10000, truncate.p = 1e-16, ...)
}
\arguments{
\item{x1}{\code{numeric} vector of effect sizes (e.g., fold change or t statitsics) for the first experiment}

\item{p1}{\code{numeric} vector of p-values for each corresponding effect size for the first experiment}

\item{x2}{\code{numeric} effect size (e.g., fold change or t statitsics) for the second experiment}

\item{p2}{\code{numeric} vector of p-values for each corresponding effect size for the second experiment}

\item{method.cor}{\code{character} string identifying if a \code{pearson} or
\code{spearman} correlation should be used}

\item{nperm}{\code{numeric} how many permutations should be done to determine}

\item{truncate.p}{\code{numeric} Truncation value for extremely low p-values}

\item{...}{Other passed down to internal functions}
}
\value{
\code{numeric} a vector of two values, the correlation and associated p-value.
}
\description{
Calculate the gwc score between two vectors, using either a weighted spearman or pearson correlation
}
\examples{
data(Cleveland_small)
x <- molecularProfiles(Cleveland_small,"rna")[,1]
y <- molecularProfiles(Cleveland_small,"rna")[,2]
x_p <- rep(0.05, times=length(x))
y_p <- rep(0.05, times=length(y))
names(x_p) <- names(x)
names(y_p) <- names(y)
gwc(x,x_p,y,y_p, nperm=100)

}
