% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coplik.R
\name{mlecop}
\alias{mlecop}
\title{Estimation of the parameter of  a bivariate copula (Clayton, Frank, Gumbel)}
\usage{
mlecop(u, v, fcopders, start = 2, LB = 1.01, UB = 7)
}
\arguments{
\item{u}{vector of values in (0,1)}

\item{v}{vector of values in (0,1)}

\item{fcopders}{ffrkders, fgumders or fmtcjders}

\item{start}{starting value for the parameter (default =2)}

\item{LB}{lower bound for the parameter (default is 1.01)}

\item{UB}{upper bound for the parameter (default is 7)}
}
\value{
\item{mle}{List of outputs from nlm function}
}
\description{
Computes the MLE estimation for a bivariate copula using gradient. The likelihood is likelihood is c(u,v;theta)
}
\examples{
set.seed(2)
v = runif(250)
w = runif(250)
u = 1/sqrt(1+(w^(-2/3)-1)/v^2) # Clayton copula with parameter 2 (tau=0.5)
out = mlecop(u,v,fmtcjders)
}
\author{
Pavel Krupskii
}
