% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicGoodValueConcept.R
\name{drawPublicGoodValue}
\alias{drawPublicGoodValue}
\title{Draw Public Good value for 3 or 4 players}
\usage{
drawPublicGoodValue(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "Normalized Public Good Value")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawPublicGoodValue draws the (normalized) Public Good value for 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
drawPublicGoodValue(v) 
}
\references{
Holler M.J. and Li X. (1995) "From public good index to public value. An axiomatic approach and generalization", Control and Cybernetics 24, pp. 257 -- 270

Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9 -- 25
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
