#' Per-capita GDP of 152 Countries from 1970 to 2003
#'
#' A dataset containing the per-capita GDP of 152 Countries over 34 years (Phillips and Sul, 2009).
#'
#'
#' \describe{
#'   \item{ID}{Country names (character);}
#'   \item{Y1970, ..., Y2003}{per-capita GDP from year 1970 to 2003.}
#' }
#'
#'
#' @docType data
#' @keywords datasets
#' @name GDP
#' @usage data(GDP)
#' @format A data frame with 152 rows and 35 variables.
#'
#' @references
#' Phillips, P. C.; Sul, D., 2009. Economic transition and growth. Journal of Applied Econometrics 24 (7), 1153-1185.
#'
#'
NULL





#' Filtered per-capita GDP of 152 Countries from 1970 to 2003
#'
#' A dataset containing the per-capita GDP of 152 Countries over 34 years (Phillips and Sul, 2009).
#' Data were filtered in order to remove business cycles.
#'
#'
#' \describe{
#'   \item{ID}{Country names (character);}
#'   \item{Y1970, ..., Y2003}{per-capita GDP from year 1970 to 2003 (filtered in order
#'    to remove business cycles).}
#' }
#'
#'
#' @docType data
#' @keywords datasets
#' @name filteredGDP
#' @usage data(filteredGDP)
#' @format A data frame with 152 rows and 35 variables.
#'
#' @references
#' Phillips, P. C.; Sul, D., 2009. Economic transition and growth. Journal of Applied Econometrics 24 (7), 1153-1185.
#'
#'
NULL
