% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stirling2.R
\name{stirling2}
\alias{stirling2}
\title{Stirling numbers of the second kind}
\usage{
stirling2(n, k)
}
\arguments{
\item{n}{(integer): the number of the objects}

\item{k}{(integer <=n): the number of the non-empty subsets (buckets)}
}
\value{
a "list" containing the following components:
\tabular{lll}{
S \tab  \tab the stirling number of the second kind\cr
SM \tab       \tab a matrix showing, for each k (on the columns) in how many ways the n objects (on the rows) can be partitioned}
}
\description{
Denote the number of ways to partition a set of n objects into k non-empty subsets
}
\examples{
parts<-stirling2(4,2)

}
\references{
Comtet, L. (1974). Advanced Combinatorics: The art of finite and infinite expansions. D. Reidel, Dordrecth, The Netherlands.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Stirling}
\keyword{kind}
\keyword{numbers}
\keyword{of}
\keyword{second}
