% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfoundedMeta.R
\name{sens_plot}
\alias{sens_plot}
\title{Plots for sensitivity analyses}
\usage{
sens_plot(.type, .q, .muB = NULL, .Bmin = log(1), .Bmax = log(5),
  .sigB = 0, .yr, .vyr = NULL, .t2, .vt2 = NULL, breaks.x1 = NULL,
  breaks.x2 = NULL, CI.level = 0.95)
}
\arguments{
\item{.type}{\code{dist} for distribution plot; \code{line} for line plot (see Details)}

\item{.q}{True effect size that is the threshold for "scientific significance"}

\item{.muB}{Single mean bias factor on log scale (only needed for distribution plot)}

\item{.Bmin}{Lower limit of lower X-axis on the log scale (only needed for line plot)}

\item{.Bmax}{Upper limit of lower X-axis on the log scale (only needed for line plot)}

\item{.sigB}{Standard deviation of log bias factor across studies (length 1)}

\item{.yr}{Pooled point estimate (on log scale) from confounded meta-analysis}

\item{.vyr}{Estimated variance of pooled point estimate from confounded meta-analysis}

\item{.t2}{Estimated heterogeneity (tau^2) from confounded meta-analysis}

\item{.vt2}{Estimated variance of tau^2 from confounded meta-analysis}

\item{breaks.x1}{Breaks for lower X-axis (bias factor) on RR scale}

\item{breaks.x2}{Breaks for upper X-axis (confounding strength) on RR scale}

\item{CI.level}{Poitnwise confidence level as a proportion}
}
\description{
Produces line plots (\code{.type=="line"}) showing the bias factor on the relative risk (RR) scale vs. the proportion
of studies with true RRs above \code{.q} (or below it for an apparently preventive relative risk).
The plot secondarily includes a X-axis scaled based on the minimum strength of confounding
to produce the given bias factor. The shaded region represents a 95\% pointwise confidence band.
Alternatively, produces distribution plots (\code{.type=="dist"}) for a specific bias factor showing the observed and 
true distributions of RRs with a red line marking the exp(\code{.q}).
}
\details{
Arguments \code{.vyr} and \code{.vt2} can be left \code{NULL}, in which case no confidence
band will appear on the line plot.
}
\examples{
# with variable bias and with confidence band
sens_plot( .type="line", .q=log(1.1), .Bmin=log(1), .Bmax=log(4), .sigB=0.1,
           .yr=log(1.3), .vyr=0.005, .t2=0.4, .vt2=0.03 )

# with fixed bias and without confidence band
sens_plot( .type="line", .q=log(1.1), .Bmin=log(1), .Bmax=log(4),
           .yr=log(1.3), .t2=0.4 )

# apparently preventive
sens_plot( .type="line", .q=log(0.90), .Bmin=log(1), .Bmax=log(4),
           .yr=log(0.6), .vyr=0.005, .t2=0.4, .vt2=0.04 )

# distribution plot
sens_plot( .type="dist", .q=log(1.1), .muB=log(2),
           .yr=log(1.3), .t2=0.4 )
}
\keyword{confounding,}
\keyword{meta-analysis,}
\keyword{sensitivity}
