% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAD.R
\name{calcAD}
\alias{calcAD}
\title{Calculate Air Density}
\usage{
calcAD(Temp, RH, P_atm = 1013.25, R_dry = 287.058, R_vap = 461.495, ...)
}
\arguments{
\item{Temp}{Temperature (°Celsius)}

\item{RH}{Relative Humidity (0-100\%)}

\item{P_atm}{Atmospheric pressure = 1013.25 (hPa)}

\item{R_dry}{Specific gas constant for dry air = 287.058 (J/(kg·K))}

\item{R_vap}{Specific gas constant for water vapor = 461.495 (J/(kg·K))}

\item{...}{Addtional arguments  to supply to \code{\link{calcPws}}}
}
\value{
Air density in kg/m³
}
\description{
Function to calculate air density based on temperature (°C), relative humidity in (\%), and atmospheric pressure (hPa).
}
\examples{
calcAD(20, 50)


# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> dplyr::mutate(AirDensity = calcAD(Temp, RH))


}
\seealso{
\code{\link{calcMR}} for calculating mixing ratio

\code{\link{calcAD}} for calculating air density

\code{\link{calcPw}} for calculating water vapour pressure

\code{\link{calcPws}} for calculating water vapour saturation pressure
}
