/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;
import net.infonode.gui.layout.LayoutUtil;
import net.infonode.util.Direction;

public class DirectionLayout
implements LayoutManager2 {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private Direction direction;
    private HashMap componentInsets;
    private int componentSpacing;
    private boolean compressing;
    private ArrayList layoutOrderList;

    public DirectionLayout() {
        this(Direction.RIGHT);
    }

    public DirectionLayout(int n) {
        this(Direction.RIGHT, n);
    }

    public DirectionLayout(Direction direction) {
        this(direction, 0);
    }

    public DirectionLayout(Direction direction, int n) {
        this.direction = direction;
        this.componentSpacing = n;
    }

    public int getComponentSpacing() {
        return this.componentSpacing;
    }

    public void setComponentSpacing(int n) {
        this.componentSpacing = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public boolean isVertical() {
        return !this.direction.isHorizontal();
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean bl) {
        this.compressing = bl;
    }

    public void setLayoutOrderList(ArrayList arrayList) {
        this.layoutOrderList = arrayList;
    }

    private int getSize(Dimension dimension) {
        return (int)(this.isVertical() ? dimension.getHeight() : dimension.getWidth());
    }

    private static int getBeforeSpacing(Insets insets) {
        return insets.left;
    }

    private int getAfterSpacing(Component component, boolean bl) {
        return this.getInsets((Component)component).right + (bl ? 0 : this.componentSpacing);
    }

    private Dimension createSize(int n, int n2) {
        return this.isVertical() ? new Dimension(n2, n) : new Dimension(n, n2);
    }

    private static Dimension getSize(Dimension dimension, Container container) {
        Insets insets = container.getInsets();
        return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
    }

    private int getOtherSize(Dimension dimension) {
        return (int)(this.isVertical() ? dimension.getWidth() : dimension.getHeight());
    }

    private void setSize(Component component, int n, int n2) {
        int n3 = this.getOtherSize(component.getMaximumSize());
        component.setSize(this.createSize(n, Math.min(n3, n2)));
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        Component[] componentArray = this.getVisibleChildren(container);
        int n4 = componentArray.length;
        if (componentArray.length == 0) {
            return;
        }
        int n5 = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            n5 += this.getSpacing(componentArray[i], i == componentArray.length - 1);
        }
        boolean[] blArray = new boolean[componentArray.length];
        Dimension dimension = LayoutUtil.getInteriorSize(container);
        int n6 = this.getSize(dimension) - n5;
        int n7 = n6 / componentArray.length;
        int n8 = this.getOtherSize(dimension);
        block1: do {
            n3 = n4;
            for (n2 = 0; n2 < componentArray.length; ++n2) {
                if (blArray[n2] || (n = this.getSize(componentArray[n2].getPreferredSize())) > n7) continue;
                this.setSize(componentArray[n2], n, n8);
                n6 -= n;
                blArray[n2] = true;
                if (--n4 == 0) continue block1;
                n7 = n6 / n4;
            }
        } while (n3 > n4);
        if (n4 > 0) {
            block3: do {
                n3 = n4;
                for (n2 = 0; n2 < componentArray.length; ++n2) {
                    if (blArray[n2] || (n = this.getSize(componentArray[n2].getMinimumSize())) < n7) continue;
                    this.setSize(componentArray[n2], n, n8);
                    n6 -= n;
                    blArray[n2] = true;
                    if (--n4 == 0) continue block3;
                    n7 = n6 / n4;
                }
            } while (n3 > n4);
        }
        Insets insets = container.getInsets();
        n = this.direction == Direction.RIGHT ? insets.left : (this.direction == Direction.DOWN ? insets.top : (this.direction == Direction.LEFT ? insets.right : insets.bottom));
        int n9 = this.isVertical() ? insets.left : insets.top;
        for (int i = 0; i < componentArray.length; ++i) {
            int n10;
            n += DirectionLayout.getBeforeSpacing(this.getInsets(componentArray[i]));
            if (!blArray[i]) {
                n10 = Math.max(this.getSize(componentArray[i].getMinimumSize()), n6 / n4);
                this.setSize(componentArray[i], n10, n8);
                --n4;
                n6 -= n10;
            }
            n10 = n9 + (int)((float)(n8 - this.getOtherSize(componentArray[i].getSize())) * (this.direction == Direction.DOWN || this.direction == Direction.LEFT ? 1.0f - componentArray[i].getAlignmentY() : componentArray[i].getAlignmentY()));
            if (this.isVertical()) {
                componentArray[i].setLocation(n10, this.direction == Direction.DOWN ? n : container.getHeight() - n - componentArray[i].getHeight());
            } else {
                componentArray[i].setLocation(this.direction == Direction.RIGHT ? n : container.getWidth() - n - componentArray[i].getWidth(), n10);
            }
            n += this.getSize(componentArray[i].getSize()) + this.getAfterSpacing(componentArray[i], i == componentArray.length - 1);
        }
    }

    public void setComponentInsets(Component component, Insets insets) {
        if (insets == null) {
            this.removeLayoutComponent(component);
        } else {
            if (this.componentInsets == null) {
                this.componentInsets = new HashMap(4);
            }
            this.componentInsets.put(component, insets);
        }
    }

    private Component[] getVisibleChildren(Container container) {
        if (this.layoutOrderList != null) {
            Component[] componentArray = new Component[this.layoutOrderList.size()];
            for (int i = 0; i < this.layoutOrderList.size(); ++i) {
                componentArray[i] = (Component)this.layoutOrderList.get(i);
            }
            return LayoutUtil.getVisibleChildren(componentArray);
        }
        return LayoutUtil.getVisibleChildren(container);
    }

    private int getSpacing(Component component, boolean bl) {
        Insets insets = this.getInsets(component);
        return insets.left + insets.right + (bl ? 0 : this.componentSpacing);
    }

    private Insets getInsets(Component component) {
        Object var2_2 = this.componentInsets == null ? null : this.componentInsets.get(component);
        return var2_2 == null ? EMPTY_INSETS : (Insets)var2_2;
    }

    public Dimension minimumLayoutSize(Container container) {
        Component[] componentArray = this.getVisibleChildren(container);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            n += this.getSize(componentArray[i].getMinimumSize()) + this.getSpacing(componentArray[i], i == componentArray.length - 1);
            n2 = Math.max(this.getOtherSize(componentArray[i].getMinimumSize()), n2);
        }
        Dimension dimension = DirectionLayout.getSize(this.isVertical() ? new Dimension(n2, n) : new Dimension(n, n2), container);
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Component[] componentArray = this.getVisibleChildren(container);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!this.compressing) {
                n += this.getSize(componentArray[i].getPreferredSize()) + this.getSpacing(componentArray[i], i == componentArray.length - 1);
            }
            n2 = Math.max(this.getOtherSize(componentArray[i].getPreferredSize()), n2);
        }
        Dimension dimension = DirectionLayout.getSize(this.isVertical() ? new Dimension(n2, n) : new Dimension(n, n2), container);
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
        if (this.componentInsets != null) {
            this.componentInsets.remove(component);
            if (this.componentInsets.size() == 0) {
                this.componentInsets = null;
            }
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        this.setComponentInsets(component, (Insets)object);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public Dimension maximumLayoutSize(Container container) {
        Component[] componentArray = this.getVisibleChildren(container);
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < componentArray.length; ++i) {
            n += this.getSize(componentArray[i].getMaximumSize()) + this.getSpacing(componentArray[i], i == componentArray.length - 1);
        }
        Dimension dimension = DirectionLayout.getSize(this.isVertical() ? new Dimension(n2, n) : new Dimension(n, n2), container);
        return dimension;
    }
}

