test_that("Poisson residual no error", {
  a <- c(0, 1, 2, 3, 4, 5, 6)
  b <- c(1, 2, 3, 4, 5, 6, 7)
  c <- c(0, 1, 0, 0, 0, 1, 0)
  d <- c(3, 4, 5, 6, 7, 8, 9)
  e <- c(0, 0, 0, 1, 1, 1, 1)
  df <- data.table("a" = a, "b" = b, "c" = c, "d" = d, "e" = e)
  keep_constant <- c(0)
  a_n <- c(-0.1)

  control <- list("ncores" = 2, "lr" = 0.95, "maxiter" = -1, "halfmax" = 1, "epsilon" = 1e-9, "deriv_epsilon" = 1e-9, "step_max" = 1.0, "change_all" = TRUE, "thres_step_max" = 1.0, "verbose" = 0)
  poisres <- PoisRun(Poisson(a, c) ~ loglinear(d, 0), df, control = control, a_n = a_n)
  expect_no_error(Residual(poisres, df, pearson = FALSE, deviance = FALSE))
  expect_no_error(Residual(poisres, df, pearson = TRUE, deviance = FALSE))
  expect_no_error(Residual(poisres, df, pearson = FALSE, deviance = TRUE))
  expect_error(Residual(poisres, df, pearson = TRUE, deviance = TRUE))
  c <- c(0, 0, 0, 0, 0, 1, 0)
  e <- c(0, 0, 0, 1, 1, 1, 1)
  df <- data.table("a" = a, "b" = b, "c" = c, "d" = d, "e" = e)
  poisres_s <- PoisRun(Poisson_Strata(a, c, e) ~ loglinear(d, 0), df, control = control, a_n = a_n)
  expect_no_error(Residual(poisres_s, df, pearson = FALSE, deviance = FALSE))
  a <- c(0, 1, 2, 3, 4, 5, 6)
  b <- c(1, 2, 3, 4, 5, 6, 7)
  c <- c(0, 0, 0, 0, 0, 0, 0)
  d <- c(3, 4, 5, 6, 7, 8, 9)
  e <- c(0, 0, 0, 1, 1, 1, 1)
  df <- data.table("a" = a, "b" = b, "c" = c, "d" = d, "e" = e)
  expect_error(Residual(poisres_s, df, pearson = FALSE, deviance = FALSE))
})
