% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Replace_Missing}
\alias{Replace_Missing}
\title{Automatically assigns missing values in listed columns
\code{Replace_Missing} checks each column and fills in NA values}
\usage{
Replace_Missing(df, name_list, MSV, verbose = FALSE)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{name_list}{vector of string column names to check}

\item{MSV}{value to replace na with, same used for every column used}

\item{verbose}{boolean to control if additional information is printed to the console}
}
\value{
returns a filled datatable
}
\description{
Automatically assigns missing values in listed columns
\code{Replace_Missing} checks each column and fills in NA values
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette

df <- data.table("UserID"=c(112, 114, 213, 214, 115, 116, 117),
           "Starting_Age"=c(18,  20,  18,  19,  21,  20,  18),
             "Ending_Age"=c(30,  45,  NA,  47,  36,  NA,  55),
          "Cancer_Status"=c(0,   0,   1,   0,   1,   0,   0))
df <- Replace_Missing(df, c("Starting_Age","Ending_Age"), 70)
}
