% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Make_Risks_Basic}
\alias{Make_Risks_Basic}
\title{Utility function to calculate the risk and risk ratios for the basic model
\code{Make_Risks_Basic} Called to update risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas}
\usage{
Make_Risks_Basic(
  totalnum,
  T0,
  R,
  Rd,
  Rdd,
  RdR,
  nthreads,
  debugging,
  df0,
  dfc,
  KeepConstant
)
}
\arguments{
\item{totalnum}{total number of parameters}

\item{T0}{Term value for each subterm}

\item{R}{risk vector}

\item{Rd}{Risk first derivative matrix}

\item{Rdd}{Risk second derivative matrix}

\item{RdR}{Risk to first derivative ratio matrix}

\item{nthreads}{number of threads available}

\item{debugging}{additional boolean for verbosity in testing}

\item{df0}{matrix of covariate values}

\item{dfc}{vector matching subterm number to matrix column}

\item{KeepConstant}{binary vector to identify constant parameters}
}
\value{
Updates matrices in place: Risk, Risk ratios
}
\description{
Utility function to calculate the risk and risk ratios for the basic model
\code{Make_Risks_Basic} Called to update risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
}
