% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Make_Groups_CR}
\alias{Make_Groups_CR}
\title{Utility function to define risk groups with competing risks
\code{Make_Groups_CR} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group, adds rows with event=2 past the event time}
\usage{
Make_Groups_CR(
  ntime,
  df_m,
  RiskFail,
  RiskGroup,
  tu,
  cens_weight,
  cens_cutoff,
  nthreads,
  debugging
)
}
\arguments{
\item{ntime}{number of risk groups}

\item{df_m}{event/time matrix}

\item{RiskFail}{matrix of indexes for event rows in each risk group}

\item{RiskGroup}{list of string indices for every risk group}

\item{tu}{Event time vector}

\item{cens_weight}{vector of censoring weights}

\item{cens_cutoff}{double threshold for adding competing risk to risk group, not implemented}

\item{nthreads}{number of threads available}

\item{debugging}{additional boolean for verbosity in testing}
}
\value{
Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
}
\description{
Utility function to define risk groups with competing risks
\code{Make_Groups_CR} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group, adds rows with event=2 past the event time
}
