% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortStats.R
\name{insertInclusionRuleNames}
\alias{insertInclusionRuleNames}
\title{Used to insert the inclusion rule names from a cohort definition set
when generating cohorts that include cohort statistics}
\usage{
insertInclusionRuleNames(
  connectionDetails = NULL,
  connection = NULL,
  cohortDefinitionSet,
  cohortDatabaseSchema,
  cohortInclusionTable = getCohortTableNames()$cohortInclusionTable
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cohortDefinitionSet}{The \code{cohortDefinitionSet} argument must be a data frame with 
the following columns: \describe{
\item{cohortId}{The unique integer identifier of the cohort} 
\item{cohortName}{The cohort's name}
\item{sql}{The OHDSI-SQL used to generate the cohort}}
Optionally, this data frame may contain: \describe{
\item{json}{The Circe JSON representation of the cohort}}}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortInclusionTable}{Name of the inclusion table, one of the tables for storing
inclusion rule statistics.}
}
\value{
A data frame containing the inclusion rules by cohort and sequence ID
}
\description{
This function will take a cohortDefinitionSet that inclusions the Circe JSON
representation of each cohort, parse the InclusionRule property to obtain
the inclusion rule name and sequence number and insert the values into the
cohortInclusionTable. This function is only required when generating cohorts
that include cohort statistics.
}
