% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measurementCohort.R
\name{measurementCohort}
\alias{measurementCohort}
\title{Create cohorts measurement based cohorts}
\usage{
measurementCohort(
  cdm,
  conceptSet,
  name,
  valueAsConcept = NULL,
  valueAsNumber = NULL
)
}
\arguments{
\item{cdm}{A cdm reference.}

\item{conceptSet}{A conceptSet, which can either be a codelist
or a conceptSetExpression.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{valueAsConcept}{A vector of cohort IDs used to filter measurements.
Only measurements with these values in the \code{value_as_concept_id} column of
the measurement table will be included. If NULL all entries independent of
their value as concept will be considered.}

\item{valueAsNumber}{A named list indicating the range of values and the unit
they correspond to, as follows:
list("unit_concept_id" = c(rangeValue1, rangeValue2)). If no name is supplied
in the list, no requirement on unit concept id will be applied. If NULL, all
entries independent of their value as number will be included.}
}
\value{
A cohort table
}
\description{
\code{measurementCohort()} creates cohorts based on patient records contained
in the measurement table. This function extends the \code{conceptCohort()} as it
allows for measurement values associated with the records to be specified.
\itemize{
\item If \code{valueAsConcept} and \code{valueAsNumber} are NULL then no requirements on
of the values associated with measurement records and using
\code{measurementCohort()} will lead to the same result as using \code{conceptCohort()}
(so long as all concepts are from the measurement domain).
\item If one of \code{valueAsConcept} and \code{valueAsNumber} is not NULL then records
will be required to have values that satisfy the requirement specified.
\item If both \code{valueAsConcept} and \code{valueAsNumber} are not NULL, records will
be required to have values that fulfill \emph{either} of the requirements
}
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor(con = NULL)
cdm$concept <- cdm$concept |>
  dplyr::union_all(
    dplyr::tibble(
      concept_id = c(4326744, 4298393, 45770407, 8876, 4124457),
      concept_name = c("Blood pressure", "Systemic blood pressure",
                       "Baseline blood pressure", "millimeter mercury column",
                       "Normal range"),
      domain_id = "Measurement",
      vocabulary_id = c("SNOMED", "SNOMED", "SNOMED", "UCUM", "SNOMED"),
      standard_concept = "S",
      concept_class_id = c("Observable Entity", "Observable Entity",
                           "Observable Entity", "Unit", "Qualifier Value"),
      concept_code = NA,
      valid_start_date = NA,
      valid_end_date = NA,
      invalid_reason = NA
    )
  )
cdm$measurement <- dplyr::tibble(
  measurement_id = 1:4,
  person_id = c(1, 1, 2, 3),
  measurement_concept_id = c(4326744, 4298393, 4298393, 45770407),
  measurement_date = as.Date(c("2000-07-01", "2000-12-11", "2002-09-08",
                                "2015-02-19")),
  measurement_type_concept_id = NA,
  value_as_number = c(100, 125, NA, NA),
  value_as_concept_id = c(0, 0, 0, 4124457),
  unit_concept_id = c(8876, 8876, 0, 0)
)
cdm <- CDMConnector::copyCdmTo(
  con = DBI::dbConnect(duckdb::duckdb()),
  cdm = cdm, schema = "main")

cdm$cohort <- measurementCohort(
  cdm = cdm,
  name = "cohort",
  conceptSet = list("normal_blood_pressure" = c(4326744, 4298393, 45770407)),
  valueAsConcept = c(4124457),
  valueAsNumber = list("8876" = c(70, 120))
)

cdm$cohort
}
}
