% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCohortCount.R
\name{tableCohortCount}
\alias{tableCohortCount}
\title{Format a summarise_characteristics object into a visual table.}
\usage{
tableCohortCount(
  result,
  type = "gt",
  header = "cohort_name",
  groupColumn = NULL,
  hide = "variable_level"
)
}
\arguments{
\item{result}{A summarise_characteristics object.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{header}{Columns to use as header. See options with
\code{tidyColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{tidyColumns(result)}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{tidyColumns(result)}.}
}
\value{
A table with a formatted version of the summariseCohortCount result
result.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)

cdm <- mockCohortCharacteristics()

result <- summariseCohortCount(cdm$cohort1)

tableCohortCount(result)

mockDisconnect(cdm = cdm)
}

}
