% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortOverlap.R
\name{plotCohortOverlap}
\alias{plotCohortOverlap}
\title{Plot the result of summariseCohortOverlap.}
\usage{
plotCohortOverlap(
  result,
  facet = NULL,
  uniqueCombinations = TRUE,
  .options = list()
)
}
\arguments{
\item{result}{A summariseCohortOverlap result.}

\item{facet}{Variables to facet by.}

\item{uniqueCombinations}{If TRUE, only unique combinations of reference and
comparator plots will be plotted.}

\item{.options}{Additional plotting options}
}
\value{
A ggplot.
}
\description{
`r lifecycle::badge("experimental")`
}
\examples{
\donttest{
library(CohortCharacteristics)
cdm <- CohortCharacteristics::mockCohortCharacteristics()
overlap <- summariseCohortOverlap(cdm$cohort2)
plotCohortOverlap(overlap)
}

}
