% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableDoseForms.R
\name{availableDoseForms}
\alias{availableDoseForms}
\title{Get the dose forms for drug concepts}
\usage{
availableDoseForms(cdm)
}
\arguments{
\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}
}
\value{
The dose forms available for drug concepts.
}
\description{
Get the dose forms for drug concepts
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()

# Get all domains available in the CDM
availableDoseForms(cdm = cdm)
}
}
