% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2.clusterData.R
\name{clusterData}
\alias{clusterData}
\title{Cluster Data Based on Different Methods}
\usage{
clusterData(
  obj = NULL,
  scaleData = TRUE,
  cluster.method = c("mfuzz", "TCseq", "kmeans", "wgcna"),
  TCseq_params_list = list(),
  object = NULL,
  min.std = 0,
  cluster.num = NULL,
  subcluster = NULL,
  seed = 5201314,
  ...
)
}
\arguments{
\item{obj}{An input object that can take one of two types:
- A \strong{cell_data_set} object for trajectory analysis.
- A \strong{matrix} or \strong{data.frame} containing expression data.}

\item{scaleData}{Logical. Whether to scale the data (e.g., z-score normalization).}

\item{cluster.method}{Character. Clustering method to use.
Options are one of \code{"mfuzz"}, \code{"TCseq"}, \code{"kmeans"}, or \code{"wgcna"}.}

\item{TCseq_params_list}{A list of additional parameters passed to the \code{TCseq::timeclust} function.}

\item{object}{A pre-calculated object required when using \code{"wgcna"} as the clustering method.}

\item{min.std}{Numeric. Minimum standard deviation for filtering expression data.}

\item{cluster.num}{Integer. The number of clusters to identify.}

\item{subcluster}{A numeric vector of specific cluster IDs to include in the results.
If \code{NULL}, all clusters are included.}

\item{seed}{An integer seed for reproducibility in clustering operations.}

\item{...}{Additional arguments passed to internal functions such as \code{pre_pseudotime_matrix}.}
}
\value{
A list containing the following clustering results:
\itemize{
\item \strong{wide.res}: A wide-format data frame with clusters and normalized expression levels.
\item \strong{long.res}: A long-format data frame for visualizations, containing cluster information,
normalized values, cluster names, and memberships.
\item \strong{cluster.list}: A list where each element contains genes belonging to a specific cluster.
\item \strong{type}: The clustering method used (\code{"mfuzz"}, \code{"TCseq"}, \code{"kmeans"}, or \code{"wgcna"}).
\item \strong{geneMode}: Currently set to \code{"none"} (reserved for future use).
\item \strong{geneType}: Currently set to \code{"none"} (reserved for future use).
}
}
\description{
Cluster Data Based on Different Methods
}
\details{
Depending on the selected \code{cluster.method}, different clustering algorithms are used:
\itemize{
\item \strong{\code{"mfuzz"}}: Applies Mfuzz soft clustering method, suitable for identifying overlapping clusters.
\item \strong{\code{"TCseq"}}: Uses TCseq clustering for time-series expression data with support for additional parameters.
\item \strong{\code{"kmeans"}}: Employs standard k-means clustering via base R's \code{stats::kmeans}.
\item \strong{\code{"wgcna"}}: Leverages pre-calculated WGCNA (Weighted Gene Co-expression Network Analysis) networks.
}

The function is designed to be flexible, allowing preprocessing (e.g., filtering by \code{min.std}),
scaling the data (\code{scaleData = TRUE}), and generating results compatible with data visualization pipelines.
}
\section{WGCNA Clustering}{

If the \strong{WGCNA} method is selected, the \code{object} parameter must contain a pre-calculated WGCNA network object.
This is typically obtained using the WGCNA package functions.
}

\section{Subsetting Clusters}{

Use the \code{subcluster} parameter to focus on specific clusters. Cluster IDs not included in the
\code{subcluster} vector will be excluded from the final results.
}

\examples{

data("exps")

# kmeans
ck <- clusterData(obj = exps,
                  cluster.method = "kmeans",
                  cluster.num = 8)

}
\author{
JunZhang

This function performs clustering on input data using one of four methods:
\strong{mfuzz}, \strong{TCseq}, \strong{kmeans}, or \strong{wgcna}. The clustering results include
metadata, normalized data, and cluster memberships.
}
