% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inert.R
\name{inert}
\alias{inert}
\title{Inertia of a cluster}
\usage{
inert(Z, indices = 1:nrow(Z), wt = rep(1/nrow(Z), nrow(Z)), M = rep(1,
  ncol(Z)))
}
\arguments{
\item{Z}{matrix data}

\item{indices}{vector representing the subset of rows}

\item{wt}{weight vector}

\item{M}{diagonal distance matrix}
}
\description{
Computes the inertia of a cluster i.e. on a subset of rows of a data matrix.
}
\examples{
data(estuary)
n <- nrow(estuary$dat)
Z <- scale(estuary$dat)*sqrt(n/(n-1))
inert(Z) # number of variables

w <- estuary$map@data$POPULATION # non uniform weights 
inert(Z,wt=w)
}

