% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_cata_format.R
\name{change_cata_format}
\alias{change_cata_format}
\title{Change format of CATA datasets to perform CATATIS or CLUSCATA function}
\usage{
change_cata_format(Data, nprod, nattr, nsub, format=1, NameProds=NULL, NameAttr=NULL)
}
\arguments{
\item{Data}{data frame or matrix. Correspond to your data}

\item{nprod}{integer. Number of products}

\item{nattr}{integer. Number of attributes}

\item{nsub}{integer. Number of subjects.}

\item{format}{integer (1 or 2). See the description}

\item{NameProds}{string vector with the names of the products (length must be nprod)}

\item{NameAttr}{string vector with the names of attributes (length must be nattr)}
}
\value{
The arranged data for CATATIS and CLUSCATA function
}
\description{
CATATIS and CLUSCATA operate on data where the blocks of binary variables are merged horizontally.
If you have a different format, you can use this function to change the format.
Format=1 is for data merged vertically with the dataset of the first subject, then the second,...
Format=2 is for data merged vertically with the dataset for the first product, then the second...
}
\seealso{
\code{\link{catatis}}, \code{\link{cluscata}}
}
\keyword{CATA}
