% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusvis.R
\docType{package}
\name{ClusVis-package}
\alias{ClusVis-package}
\alias{ClusVis}
\title{Model-based visualization of model-based clustering.}
\description{
The main function for parameter inference is \link{clusvis}.
However, specific functions for parameter inference  \link{clusvisMixmod} are implemented to deal with model-based clustering done with R packages Rmixmod and Rmixcomp respectively.
After parameter inference, visualization is done with function \link{plotDensityClusVisu}.
}
\details{
\tabular{ll}{
  Package: \tab ClusVis\cr
  Type: \tab Package\cr
  Version: \tab 1.0.0\cr
  Date: \tab 2017-07-10\cr
  License: \tab GPL-2\cr
  LazyLoad: \tab yes\cr
}
}
\examples{
\dontrun{
### Categorical data clustering
# Package loading
require(Rmixmod)
 
# Data loading (categorical data)
data(birds)

# Model-based clustering with 3 components
resmixmod <- mixmodCluster(birds, 3)

# Inference of the parameters used for results visualization (general approach)
# Probabilities of classification are not sampled from the model parameter,
# but observed probabilities of classification are used for parameter estimation
resvisu <- clusvis(log(resmixmod@bestResult@proba),
                   resmixmod@bestResult@parameters@proportions)

# Inference of the parameters used for results visualization
# (specific for Rmixmod results)
# It is better because probabilities of classification are generated
# by using the model parameters
resvisu <- clusvisMixmod(resmixmod)

# Component interpretation graph
plotDensityClusVisu(resvisu)

# Scatter-plot of the observation memberships
plotDensityClusVisu(resvisu,  add.obs = TRUE)
}
}
\author{
Biernacki, C. and Marbac, M. and Vandewalle, V.
}
\keyword{package}
