% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpCommunitySizeDistribution.R
\name{cpCommunitySizeDistribution}
\alias{cpCommunitySizeDistribution}
\title{Plotting Clique Percolation Community Size Distribution}
\usage{
cpCommunitySizeDistribution(list.of.communities, color.line = "#bc0031")
}
\arguments{
\item{list.of.communities}{List object taken from results of cpAlgorithm
function; see also \link{cpAlgorithm}}

\item{color.line}{string indicating the color of the line in the plot as described
in \link[graphics]{par}; default is \code{"#bc0031"}}
}
\value{
The function primarily plots the community size distribution. Additionally, it returns
  a list with a data frame containing all community sizes and their frequencies
  (\code{size.distribution}).
}
\description{
Function for plotting the frequency distribution of community sizes from clique
percolation community detection.
}
\details{
The function takes the results of cpAlgorithm (see also \link{cpAlgorithm}),
  that is, either the \code{list.of.communities.numbers} or the
  \code{list.of.communities.labels} and plots the community size distribution. If there
  are no communities, no plot can be generated. An error is printed indicating this.
}
\examples{
# create qgraph object; 150 nodes; 1/7 of all edges are different from zero
W <- matrix(c(0), nrow = 150, ncol = 150, byrow = TRUE)
set.seed(4186)
W[upper.tri(W)] <- sample(c(rep(0,6),1), length(W[upper.tri(W)]), replace = TRUE)
rand_w <- stats::rnorm(length(which(W == 1)), mean = 0.3, sd = 0.1)
W[which(W == 1)] <- rand_w
W <- Matrix::forceSymmetric(W)
W <- qgraph::qgraph(W, DoNotPlot = TRUE)

# run clique percolation for weighted networks
cp.results <- cpAlgorithm(W, k = 3, method = "weighted", I = 0.38)

# plot community size distribution with blue line
cp.size.dist <- cpCommunitySizeDistribution(cp.results$list.of.communities.numbers,
                                            color.line = "#0000ff")

}
\author{
Jens Lange, \email{lange.jens@outlook.com}
}
