% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.quali.hlev.R
\name{report.quali.hlev}
\alias{report.quali.hlev}
\title{'Hierarchical Qualitative' statistics reporting (experimental)}
\usage{
report.quali.hlev(data, subjid = NULL, x1 = NULL, var_upper, var_lower,
  lower.levels = "Lower.Levels", upper.levels = "Upper.Levels",
  x1.label = NULL)
}
\arguments{
\item{data}{A data frame}

\item{subjid}{A character}

\item{x1}{A character. Indicates a factor in the data frame.}

\item{var_upper}{A character. Indicates a factor in the data frame which corresponds to the factor with the higher number of levels (typically SOC variable)}

\item{var_lower}{A character. Indicates a factor in the data frame which corresponds to the factor with the lower number of levels (typically PT variable)}

\item{lower.levels}{A character. The label to be displayed in the table for the lower terms}

\item{upper.levels}{A character. The label to be displayed in the table for the upper terms}

\item{x1.label}{A character. Not used for now}
}
\value{
A desc object that can be used by the \code{report.doc} function.
}
\description{
This function is mainly used to compute qualitative statistics when there are several events per
statistical unit. Often used for reporting adverse events, medical history or concomitant treatments.

It reports frequencies and percentages according to hierarchical levels of two factors.

Typically, adverse event are classified according to System Organ Class (SOC)
and then sub classified by Prefered Terms (PT). Several observations of a same adverse event can 
be observed several times on the same subject. 
It's then useful to know how many persons are concerned by at least one of those adverse events
and report the frequencies for each classifications: SOC and PT.

This is exactly what this function does.

For more examples see the website: \href{https://jfrancoiscollin.github.io/ClinReport}{ClinReport website}
}
\details{
The subjid argument is mandatory for this function.
}
\examples{

data(adverse_event)

test=report.quali.hlev(data=adverse_event,subjid="SUBJID",var_upper="PTNAME",
var_lower="SOCNAME",lower.levels="System Organ Class",upper.levels="Prefered Terms",x1="randtrt")

# show results in console
test

# show formatted results in HTML
ft=report.doc(test,valign=TRUE)
ft

}
\seealso{
\code{\link{report.quali}} \code{\link{emmeans}} \code{\link{report.doc}} \code{\link{desc}}
}
