% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeightedCells.R
\name{WeightedCells}
\alias{WeightedCells}
\title{Compute the square-root of the cosine of the latitude weighting on the given 
array.}
\usage{
WeightedCells(data, lat, lat_dim = "lat", method = "cos", ncores = NULL)
}
\arguments{
\item{data}{A numeric array with named dimensions, representing the data to be
applied the weights. It should have at least the latitude dimension and it 
can have more other dimensions.}

\item{lat}{A numeric vector or array with one dimension containing the 
latitudes (in degrees).}

\item{lat_dim}{A character string indicating the name of the latitudinal
dimension. The default value is 'lat'.}

\item{method}{A character string indicating the type of weighting applied: 
'cos' (cosine of the latitude) or 'sqrtcos' (square-root of the 
cosine of the latitude). The default value is 'cos'.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
An array containing the latitude weighted data with same dimensions as
parameter 'data'.
}
\description{
This function performs square-root of the cosine of the latitude weighting on 
the given array.
}
\examples{
exp <- array(rnorm(1:30), dim = c(lat = 3, lon = 5, sdate = 2))
lat <- c(10, 15, 20)
res <- WeightedCells(data = exp, lat = lat)
}
