% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelBox.R
\name{SelBox}
\alias{SelBox}
\title{Select apatial region from multidimensional arrays}
\usage{
SelBox(data, lon, lat, region, londim = NULL, latdim = NULL, mask = NULL)
}
\arguments{
\item{data}{An array with minimum two dimensions of latitude and longitude.}

\item{lon}{Numeric vector of longitude locations of the cell centers of the grid of \code{data}'.}

\item{lat}{Numeric vector of latitude locations of the cell centers of the grid of \code{data}'.}

\item{region}{A vector of length four indicating the minimum longitude, the maximum longitude, the minimum latitude and the maximum latitude.}

\item{londim}{An integer number indicating the position of the longitude dimension in the \code{data} object. If NULL (by deafault), the function search for a dimension call 'lon' in the \code{data} input.}

\item{latdim}{An integer number indicating the position of the latitude dimension in the \code{data} object.  If NULL (by deafault), the function search for a dimension call 'lat' in the \code{data} input.}

\item{mask}{A matrix with the same spatial dimensions of \code{data}.}
}
\value{
A list of length 4:
\itemize{
 \item\code{$data}{An array with the same dimensions as the input \code{data} array, but with spatial dimension reduced to the selected \code{region}}
 \item\code{$lat}{A vector with the new corresponding latitudes for the selected \code{region}}
 \item\code{$lon}{A vector with the new corresponding longitudes for the selected \code{region}}
 \item\code{$mask}{If parameter \code{mask} is supplied, an array  with reduced length of the dimensions to the selected \code{region}. Otherwise, a NULL element is returned.}}
}
\description{
This function subsets an spatial region from spatial data giving a vector with the maximum and minimum of latitudes and longitudes of the selected region.
}
\examples{
## Example with synthetic data:
data <- 1:(20 * 3 * 2 * 4)
dim(data) <- c(lon = 20, lat = 3, time = 2, model = 4)
lon <- seq(2, 40, 2)
lat <- c(1, 5, 10)

a <- SelBox(data = data, lon = lon, lat = lat, region = c(2, 20, 1, 5), 
           londim = 1, latdim = 2, mask = NULL)
str(a)
}
