% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAtmoFlows.R
\name{getAtmoFlows}
\alias{getAtmoFlows}
\title{Gather all atmospheric data time series}
\usage{
getAtmoFlows(start, end, geometry, att, val = NA, latitude)
}
\arguments{
\item{start}{start date in format 'YYYY-MM-DD'}

\item{end}{end date in format 'YYYY-MM-DD'}

\item{geometry}{name of geometry as displayed in GDP}

\item{att}{attribute of geometry as displayed in GDP}

\item{val}{values of attribute as displayed in GDP}

\item{latitude}{(degrees)}
}
\value{
xts object consisting of:
 \item{prcp}{precipitation (mm)}
 \item{et}{evapotranspiration (mm)}
 \item{tmax}{max temperature (deg C)}
 \item{tmin}{min temperature (deg C)}
 \item{pet}{potential evapotranspiration (mm)}
}
\description{
This function gathers precipitation, evapotranspiration and temperature data 
from the USGS Geo Data Portal (GDP), and calculates potential 
evapotranspiration. NOTE:  Shapefile for geometry must already be uploaded to 
the GDP.
}
\examples{
\dontrun{
atm <- getAtmoFlows('2010-01-01', '2010-12-31', 'sample:Counties', 'STATE','RI',
41.5801)
}
}
