% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_par_values.R
\name{make_values_task_list}
\alias{make_values_task_list}
\title{Make values task list}
\usage{
make_values_task_list(
  distribution = NA,
  x = NA,
  node = NA,
  label = NA,
  statement = NA,
  confound = NA,
  nodal_type = NA,
  param_names = NA,
  param_set = NA
)
}
\arguments{
\item{distribution}{A string (or list of strings) indicating a common prior distribution (uniform, jeffreys or certainty)}

\item{x}{Real positive numbers. For priors these are hyperparameters of the Dirichlet distribution. For parameters these are probabilities.}

\item{node}{A string (or list of strings) indicating nodes for which priors are to be altered}

\item{label}{A string. Label for nodal type indicating nodal types for which priors are to be altered}

\item{statement}{A causal query (or list of queries) that determines nodal types for which priors are to be altered}

\item{confound}{A confound named list that restricts nodal types for which priors are to be altered. Adjustments are limited to nodes in the named list.}

\item{nodal_type}{String. Label for nodal type indicating nodal types for which priors are to be altered}

\item{param_names}{String. The name of specific parameter in the form of, for example, 'X.1', 'Y.01'}

\item{param_set}{String. Indicates the name of the set of parameters to be modified (useful when setting confounds)}
}
\value{
An \code{array} of parameter arguments.

For instance \code{confound = list(X  = Y[X=1]> Y[X=0])} adjust parameters on X that are conditional on nodal types for Y.
}
\description{
A function to generate a list of parameter arguments.
}
\examples{
CausalQueries:::make_values_task_list(node = 'X', x = 3)
CausalQueries:::make_values_task_list(node = c('X', 'Y'), x = 2:3)
CausalQueries:::make_values_task_list(node = c('X', 'Y'), x = list(1, 2:4))
}
\seealso{
Other priors: 
\code{\link{get_priors}()},
\code{\link{make_par_values_multiple}()},
\code{\link{make_par_values}()},
\code{\link{make_priors}()},
\code{\link{set_priors}()}
}
\concept{priors}
