% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbsts_mcmc.R
\name{mcmc}
\alias{mcmc}
\title{MCMC samples for a given MBSTS model}
\usage{
mcmc(
  Smodel,
  X = NULL,
  H = NULL,
  nu0.r = NULL,
  s0.r,
  nu0.eps = NULL,
  s0.eps,
  niter,
  burn,
  ping = NULL
)
}
\arguments{
\item{Smodel}{A multivariate state space model of class \code{SSModel}.}

\item{X}{t x N optional matrix of predictors.}

\item{H}{P x P variance-covariance matrix of the regression coefficients. Set
by default to H = c(X'X)^(-1) which is akin to the Zellner's g-prior. The
value of the scaling factor is set to \code{c = 1}. Alternative priors
could be H = c*diag((X'X)^(-1)) or H = c*I. See also Smith & Kohn, 1995
that suggest setting \code{c} in the range [10,1000].}

\item{nu0.r}{Degrees of freedom of the Inverse-Wishart prior for each
Sigma.r. Set by default to n0.r = d + 2, where d is the number of time
series in the multivariate model.}

\item{s0.r}{Scale matrix of the Inverse-Wishart prior for each Sigma.r, a
vector of errors for state r. Must be a (d x d) positive definite. Default
set to the variance-covariance matrix of y multiplied by a scaling factor
of 0.01.}

\item{nu0.eps}{Degrees of freedom of the Inverse-Wishart prior for Sigma.eps,
a vector of observation errors for each time series. Set by default to d + 2
(must be greater than d - 1).}

\item{s0.eps}{Scale matrix of the Inverse-Wishart prior for Sigma.eps, a
vector of observation errors for each time series. Must be a (d x d)
positive definite. Default set to the variance-covariance matrix of y
multiplied by a scaling factor of 0.01.}

\item{niter}{Number of MCMC iterations.}

\item{burn}{Desired burn-in, set by default to 0.1 * \code{niter}.}

\item{ping}{A status message is printed every \code{ping} iteration. Default
set to 0.1 * \code{niter}. Set to 0 to not track the status.}
}
\value{
An object of class 'mbsts' which is a list with the following components:
\describe{
  \item{eta.samples}{(\code{niter}- \code{burn}) draws from the distribution of eta_r.}
  \item{eps.samples}{(\code{niter}- \code{burn}) draws from the distribution of eps.}
  \item{states.samples}{(\code{niter}- \code{burn}) draws from p(alpha_t | Y_{1:T}).}
  \item{Sigma.r}{(\code{niter}- \code{burn}) draws from the posterior distribution of Sigma.r.}
  \item{Sigma.eps}{(\code{niter}- \code{burn}) draws from the posterior distribution of Sigma.eps.}
  \item{Z.beta}{(\code{niter}- \code{burn}) x P matrix of the models selected at each iteration
                (if a matrix of predictors is provided).}
  \item{beta}{ P x d x (\code{niter}- \code{burn}) ) array of the draws from the posterior
               distribution of the regression coefficient matrix (if a matrix of predictors is provided).}
  \item{X}{Predictor matrix (if provided).}
  \item{y}{Matrix of observations.}
  \item{Z}{(d x m) selection matrix of the observation equation.}
  \item{Tt}{(m x m) matrix of the state equation.}
  \item{R}{(m x r) matrix selecting the state disturbances.}
  \item{niter}{Number of mcmc iterations.}
  \item{burn}{Burn-in.}
}
}
\description{
Use MCMC to sample from the joint posterior of model parameters in an mbsts model.
}
\examples{
## Example 1 : local level + seasonal (d = 3)
y <- cbind(seq(0.5,100,by=0.5)*0.1 + rnorm(200),
           seq(100.25,150,by=0.25)*0.05 + rnorm(200),
           rnorm(200, 5,1))
model.1 <- model(y = y, components = c("trend", "seasonal"), seas.period = 7)
mcmc.1 <- mcmc(model.1, s0.r = diag(3), s0.eps = diag(3), niter = 50, burn = 5)

## Example 2 : local level + seasonal + covariates (d = 2)
y <- cbind(rnorm(100), rnorm(100, 2, 3))
X <- cbind(rnorm(100, 0.5, 1) + 5, rnorm(100, 0.2, 2) - 2)
model.2 <- model(y = y, components = c("trend", "seasonal"), seas.period = 7)
mcmc.2 <- mcmc(model.2, X = X, s0.r = diag(2), s0.eps = diag(2), niter = 100, burn = 10)
}
\keyword{internal}
