% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs_bu.R
\name{catr_wfs_get_buildings_bbox}
\alias{catr_wfs_get_buildings_bbox}
\alias{catr_wfs_get_buildings_rc}
\title{WFS INSPIRE: Download Buildings}
\usage{
catr_wfs_get_buildings_bbox(x, what = "building", srs, verbose = FALSE)

catr_wfs_get_buildings_rc(rc, what = "building", srs = NULL, verbose = FALSE)
}
\arguments{
\item{x}{See \strong{Details}. It could be:
\itemize{
\item A numeric vector of length 4 with the coordinates that defines
the bounding box: \code{c(xmin, ymin, xmax, ymax)}
\item A \code{sf/sfc} object, as provided by the \strong{sf} package.
}}

\item{what}{Information to load. It could be \code{"building"} for buildings,
\code{"buildingpart"} for parts of a building or \code{"other"} for others (
swimming pools, etc.).}

\item{srs}{SRS/CRS to use on the query. To check the admitted values check
\link{catr_srs_values}, specifically the \code{wfs_service} column. See \strong{Details}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{rc}{The cadastral reference to be extracted.}
}
\value{
A \code{sf} object.
}
\description{
Get the spatial data of buildings. The WFS Service allows to perform
two types of queries:
\itemize{
\item By bounding box: Implemented on \code{catr_wfs_get_buildings_bbox()}. Extract objects
included on the bounding box provided. See \strong{Details}.
}

\itemize{
\item By cadastral reference: Implemented on \code{catr_wfs_get_buildings_rc()}. Extract
objects of specific cadastral references.
}

Check the
\href{https://www.catastro.minhap.es/webinspire/documentos/inspire-bu-WFS.pdf}{API Docs}.
}
\details{
When \code{x} is a numeric vector, make sure that the \code{srs} matches the
coordinate values. Additionally, when the \code{srs} correspond to a geographic
reference system (4326, 4258), the function queries the bounding box on
\href{https://epsg.io/3857}{EPSG:3857} - Web Mercator, to overcome
a potential bug on the API side. The result is provided always in the SRS
provided in \code{srs}.

When \code{x} is a \code{sf} object, the value \code{srs} is ignored. The query is
performed using \href{https://epsg.io/3857}{EPSG:3857} (Web Mercator) and the
spatial object is projected back to the SRS of the initial object.
}
\section{API Limits}{
The API service is limited to a bounding box of 4km2 and a maximum of 5.000
elements.
}

\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "linux") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Using bbox
building <- catr_wfs_get_buildings_bbox(c(
  376550,
  4545424,
  376600,
  4545474
),
srs = 25830
)
library(ggplot2)
ggplot(building) +
  geom_sf() +
  labs(title = "Search using bbox")

# Using rc
rc <- catr_wfs_get_buildings_rc("6656601UL7465N")
library(ggplot2)
ggplot(rc) +
  geom_sf() +
  labs(title = "Search using rc")
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://www.catastro.minhap.es/webinspire/documentos/inspire-bu-WFS.pdf}{API Documentation}

\href{https://www.catastro.minhap.es/webinspire/index.html}{INSPIRE Services for Cadastral Cartography}
}
\seealso{
\code{\link[sf:st_bbox]{sf::st_bbox()}}

INSPIRE API functions:
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()}

Other INSPIRE WFS services:
\code{\link{catr_srs_values}},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()}

Other buildings: 
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_buildings}()}

Other spatial: 
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()}
}
\concept{INSPIRE}
\concept{WFS}
\concept{buildings}
\concept{spatial}
