% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{sign-methods}
\alias{sign-methods}
\alias{is_zero}
\alias{is_nonneg}
\alias{is_nonpos}
\title{Sign Properties}
\usage{
is_zero(object)

is_nonneg(object)

is_nonpos(object)
}
\arguments{
\item{object}{An \linkS4class{Expression} object.}
}
\value{
A logical value.
}
\description{
Determine if an expression is positive, negative, or zero.
}
\examples{
pos <- Constant(1)
neg <- Constant(-1)
zero <- Constant(0)
unknown <- Variable()

is_zero(pos)
is_zero(-zero)
is_zero(unknown)
is_zero(pos + neg)

is_nonneg(pos + zero)
is_nonneg(pos * neg)
is_nonneg(pos - neg)
is_nonneg(unknown)

is_nonpos(-pos)
is_nonpos(pos + neg)
is_nonpos(neg * zero)
is_nonpos(neg - pos)
}
