% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{NormNuc-class}
\alias{NormNuc-class}
\alias{.NormNuc}
\alias{NormNuc}
\alias{NormNuc}
\alias{to_numeric,NormNuc-method}
\alias{size_from_args,NormNuc-method}
\alias{sign_from_args,NormNuc-method}
\alias{is_atom_convex,NormNuc-method}
\alias{is_atom_concave,NormNuc-method}
\alias{is_incr,NormNuc-method}
\alias{is_decr,NormNuc-method}
\alias{graph_implementation,NormNuc-method}
\title{The NormNuc class.}
\usage{
NormNuc(A)

\S4method{to_numeric}{NormNuc}(object, values)

\S4method{size_from_args}{NormNuc}(object)

\S4method{sign_from_args}{NormNuc}(object)

\S4method{is_atom_convex}{NormNuc}(object)

\S4method{is_atom_concave}{NormNuc}(object)

\S4method{is_incr}{NormNuc}(object, idx)

\S4method{is_decr}{NormNuc}(object, idx)

\S4method{graph_implementation}{NormNuc}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{A}{An \linkS4class{Expression} representing a matrix.}

\item{object}{A \linkS4class{NormNuc} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
The nuclear norm, i.e. sum of the singular values of a matrix.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The nuclear norm (i.e., the sum of the singular values) of \code{A}.

\item \code{size_from_args}: The atom is a scalar.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: The atom is not monotonic in any argument.

\item \code{is_decr}: The atom is not monotonic in any argument.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{A}}{An \linkS4class{Expression} representing a matrix.}
}}

