% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{log_sum_exp}
\alias{log_sum_exp}
\title{Log-Sum-Exponential}
\usage{
log_sum_exp(x, axis = NA_real_)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or matrix.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}
}
\value{
An \linkS4class{Expression} representing the log-sum-exponential of the input.
}
\description{
The natural logarithm of the sum of the elementwise exponential, \eqn{\log\sum_{i=1}^n e^{x_i}}.
}
\examples{
A <- Variable(2,2)
val <- cbind(c(5,7), c(0,-3))
prob <- Problem(Minimize(log_sum_exp(A)), list(A == val))
result <- solve(prob)
result$getValue(A)
}
