% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{expression-parts}
\alias{expression-parts}
\alias{variables}
\alias{parameters}
\alias{constants}
\title{Parts of an Expression}
\usage{
variables(object)

parameters(object)

constants(object)
}
\arguments{
\item{object}{A \linkS4class{Canonical} expression.}
}
\value{
A list of \linkS4class{Variable}, \linkS4class{Parameter}, or \linkS4class{Constant} objects.
}
\description{
List the variables, parameters, or constants in a canonical expression.
}
\examples{
m <- 50
n <- 10
beta <- Variable(n)
y <- matrix(rnorm(m), nrow = m)
X <- matrix(rnorm(m*n), nrow = m, ncol = n)
lambda <- Parameter()

expr <- sum_squares(y - X \%*\% beta) + lambda*p_norm(beta, 1)
variables(expr)
parameters(expr)
constants(expr)
lapply(constants(expr), function(c) { value(c) })
}
