% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_MultiEOF.R
\name{MultiEOF}
\alias{MultiEOF}
\title{EOF analysis of multiple variables starting from an array (reduced 
version)}
\usage{
MultiEOF(
  data,
  lon,
  lat,
  dates,
  time = NULL,
  lon_dim = "lon",
  lat_dim = "lat",
  time_dim = "ftime",
  sdate_dim = "sdate",
  var_dim = "var",
  neof_max = 40,
  neof_composed = 5,
  minvar = 0.6,
  lon_lim = NULL,
  lat_lim = NULL,
  ncores = NULL
)
}
\arguments{
\item{data}{A multidimensional array with dimension \code{"var"}, containing 
the variables to be analysed. The other diemnsions follow the same structure
as the \code{"exp"} element of a 's2dv_cube' object. Latitudinal 
dimension accepted names: 'lat', 'lats', 'latitude', 'y', 'j', 'nav_lat'. 
Longitudinal dimension accepted names: 'lon', 'lons','longitude', 'x', 'i', 
'nav_lon'. NAs can exist but it should be consistent along 'time_dim'. That 
is, if one grid point has NAs for each variable, all the time steps at this 
point should be NAs.}

\item{lon}{Vector of longitudes.}

\item{lat}{Vector of latitudes.}

\item{dates}{Vector or matrix of dates in POSIXct format.}

\item{time}{Deprecated parameter, it has been substituted by 'dates'. It will 
be removed in the next release.}

\item{lon_dim}{A character string indicating the name of the longitudinal 
dimension. By default, it is set to 'lon'.}

\item{lat_dim}{A character string indicating the name of the latitudinal 
dimension. By default, it is set to 'lat'.}

\item{time_dim}{A character string indicating the name of the temporal 
dimension. By default, it is set to 'time'.}

\item{sdate_dim}{A character string indicating the name of the start date 
dimension. By default, it is set to 'sdate'.}

\item{var_dim}{A character string indicating the name of the variable 
dimension. By default, it is set to 'var'.}

\item{neof_max}{Maximum number of single eofs considered in the first 
decomposition.}

\item{neof_composed}{Number of composed eofs to return in output.}

\item{minvar}{Minimum variance fraction to be explained in first decomposition.}

\item{lon_lim}{Vector with longitudinal range limits for the calculation for 
all input variables.}

\item{lat_lim}{Vector with latitudinal range limits for the calculation for 
all input variables.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list containing:
\item{coeff}{
 An array of principal components with dimensions 'time_dim', 'sdate_dim', 
 number of eof, rest of the dimensions of 'data' except 'lon_dim' and 
 'lat_dim'. 
}
\item{variance}{
 An array of explained variances with dimensions 'eof' and the rest of the 
 dimensions of 'data' except 'time_dim', 'sdate_dim', 'lon_dim' and 
 'lat_dim'.
}
\item{eof_pattern}{
 An array of EOF patterns obtained by regression with dimensions: 'eof' and 
 the rest of the dimensions of 'data' except 'time_dim' and 'sdate_dim'.
}
\item{mask}{
 An array of the mask with dimensions ('lon_dim', 'lat_dim', rest of the 
 dimensions of 'data' except 'time_dim'). It is made from 'data', 1 for the 
 positions that 'data' has value and NA for the positions that 'data' has NA. 
 It is used to replace NAs with 0s for EOF calculation and mask the result 
 with NAs again after the calculation.
}
\item{coordinates}{
 Longitudinal and latitudinal coordinates vectors.
}
}
\description{
This function performs EOF analysis over multiple variables, 
accepting in input an array with a dimension \code{"var"} for each variable to 
analyse. Based on Singular Value Decomposition. For each field the EOFs are 
computed and the corresponding PCs are standardized (unit variance, zero mean); 
the minimum number of principal components needed to reach the user-defined 
variance is retained. The function weights the input data for the latitude 
cosine square root.
}
\examples{
exp <- array(runif(1280)*280, dim = c(dataset = 2, member = 2, sdate = 3, 
                                     ftime = 3, lat = 4, lon = 4, var = 1))
lon <- seq(0, 3)
lat <- seq(47, 44)
dates <- c("2000-11-01", "2000-12-01", "2001-01-01", "2001-11-01", 
          "2001-12-01", "2002-01-01", "2002-11-01", "2002-12-01", "2003-01-01")
Dates <- as.POSIXct(dates, format = "\%Y-\%m-\%d")
dim(Dates) <- c(ftime = 3, sdate = 3)
cal <- MultiEOF(data = exp, lon = lon, lat = lat, dates = Dates)
}
\author{
Jost von Hardenberg - ISAC-CNR, \email{j.vonhardenberg@isac.cnr.it}

Paolo Davini - ISAC-CNR, \email{p.davini@isac.cnr.it}
}
