% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRPClustering.R
\name{crp_gibbs}
\alias{crp_gibbs}
\title{Markov chain Monte Carlo methods for CRP clustering}
\usage{
crp_gibbs(data, mu = c(0, 0), sigma = 0.5, sigma_table = 12, alpha = 1,
  ro_0 = 0.1, burn_in = 10, iteration = 100)
}
\arguments{
\item{data}{: a matrix of data for clustering. Row is each data_i and column is dimensions of each data_i.}

\item{mu}{: a vector of center points of data. If data is 3 dimensions, a vector of 3 elements like c(2,4,2).}

\item{sigma}{: a numeric of data variance.}

\item{sigma_table}{: a numeric of CRP variance.}

\item{alpha}{: a numeric of a CRP concentrate rate.}

\item{ro_0}{: a numeric of a CRP mu change rate.}

\item{burn_in}{:  an iteration integer of burn in.}

\item{iteration}{: an iteration integer.}
}
\value{
z_result : a vector expresses cluster numbers for each data_i.
}
\description{
Markov chain Monte Carlo methods for CRP clustering
}
\examples{
z_result <- crp_gibbs(matrix(c(0.1,0.1,0.2,0.2,0.3,0.3,1.4,1.4,1.5,1.5),2,2),
 mu=c(0,0), sigma=0.5, sigma_table=12, alpha=1, ro_0=0.1, burn_in=10, iteration=100)
}
