% Generated by roxygen2 (4.0.1): do not edit by hand
\name{decode.sample}
\alias{decode.sample}
\title{Decoding method using sampling}
\usage{
decode.sample(crf, sample.method, ...)
}
\arguments{
\item{crf}{The CRF}

\item{sample.method}{The sampling method}

\item{...}{The parameters for \code{sample.method}}
}
\value{
This function will return the most likely configuration, which is a vector of length \code{crf$n.nodes}.
}
\description{
Computing the most likely configuration for CRF
}
\details{
Approximate decoding using sampling (takes a sampling method as input)
}
\examples{
library(CRF)
data(Small)
d <- decode.sample(Small$crf, sample.exact, 10000)
}

