% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindowVec.R
\name{WindowVec}
\alias{WindowVec}
\title{WindowVec is a function to specify window size for each order of COREs}
\usage{
WindowVec(InputData, peakNumMin, WScutoff)
}
\arguments{
\item{InputData}{The input data as a table including chromosome regions in
which the first column is chromosome annotation,  and second and third
columns are start and ending positions.}

\item{peakNumMin}{Minimum order of COREs}

\item{WScutoff}{Threshold used to identify WS within distribution of maximum distance between peaks for each order of CORE}
}
\value{
Vector of window sizes from order 2 up to maximum order of COREs
}
\description{
WindowVec is a function to specify window size for each order of COREs
}
\examples{
InputData <- read.table(system.file("extdata", "A549_Chr21.bed",
package = "CREAM"), sep="\\t")
colnames(InputData) <- c("chr", "start", "end")
MinLength <- 1000
if(nrow(InputData) < MinLength){
   stop(paste( "Number of functional regions is less than ", MinLength,
   ".", sep = "", collapse = ""))
}
peakNumMin <- 2
WScutoff <- 1.5
WindowVecFinal <- WindowVec(InputData, peakNumMin, WScutoff)
}
