% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R
\name{correlate}
\alias{correlate}
\title{Test for Bivariate Correlation}
\usage{
correlate(x, y, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{...}{arguments passed to \code{\link{cor.test}()}.}
}
\value{
Returns a list with elements containing the correlation coefficient estimate, its associated
standard error, the p-value of a null-hypothesis significance test, and the number of observations
used, all as numeric vectors of length 1.
}
\description{
Calculates correlation coefficient between two variables and returns a list containing the
correlation estimate, its standard error, the p-value of a null-hypothesis significance test, and the
number of observations used.
}
\details{
Additional arguments to alter the type of null hypothesis significance test, the method used to
calculate the correlation coefficient, the confidence level, or other options should be passed to
\code{correlate}() and will be inherited by \code{\link{cor.test}()}. Note that unlike
\code{\link{cor.test}()}, both arguments \code{x} and \code{y} are required.
}
\examples{
data <- matrix(c(rnorm(50, 0, 1), rnorm(50, 5, 1)), ncol = 2, byrow = TRUE)

correlate(data[, 1], data[, 2])

}
