% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{COMPoissonReg-package}
\alias{COMPoissonReg-package}
\title{Estimate parameters for COM-Poisson regression}
\description{
This package offers the ability to compute the parameter estimates
for a COM-Poisson or zero-inflated (ZI) COM-Poisson regression and
associated standard errors.  This package also provides a hypothesis
test for determining statistically significant data dispersion, and
other model diagnostics.
}
\details{
This package offers the ability to compute COM-Poisson parameter
estimates and associated standard errors for a regular regression
model or a zero-inflated regression model (via the \code{glm.cmp}
function).

Further, the user can perform a hypothesis test to determine the
statistically significant need for using COM-Poisson regression
to model the data.  The test addresses the matter of statistically
significant dispersion.

The main order of functions for COM-Poisson regression is as follows:
\enumerate{
\item Compute Poisson estimates (using \code{glm} for Poisson regression
    or \code{pscl} for ZIP regression).
\item Use Poisson estimates as starting values to determine COM-Poisson
    estimates (using \code{glm.cmp}).
\item Compute associated standard errors (using \code{sdev} function).
}

From here, there are many ways to proceed, so order is irrelevant:
\itemize{
\item Perform a hypothesis test to assess for statistically significant
      dispersion (using \code{equitest} or \code{parametric.bootstrap}).
\item Compute leverage (using leverage) and deviance (using deviance).
\item Predict the outcome for new examples, using predict.
}

The package also supports fitting of the zero-inflated COM-Poisson model
(ZICMP). Most of the tools available for COM-Poisson are also available
for ZICMP.

As of version 0.5.0 of this package, a hybrid method is used to compute
the normalizing constant \eqn{z(\lambda, \nu)} for the COM-Poisson density.
A closed-form approximation (Shmueli et al, 2005; Gillispie & Green, 2015)
to the exact sum is used if the given \eqn{\lambda} is sufficiently large
and \eqn{\nu} is sufficiently small. Otherwise, an exact summation is used,
except that the number of terms is truncated to meet a given accuracy.
Previous versions of the package used simple truncation (defaulting to 100
terms), but this was found to be inaccurate in some settings.

See the package vignette for a more comprehensive guide on package use and
explanations of the computations.
}
\references{
Steven B. Gillispie & Christopher G. Green (2015) Approximating the
Conway-Maxwell-Poisson distribution normalization constant, Statistics,
49:5, 1062-1073.

Kimberly F. Sellers & Galit Shmueli (2010). A Flexible Regression Model for
Count Data. Annals of Applied Statistics, 4(2), 943-961.

Kimberly F. Sellers and Andrew M. Raim (2016). A Flexible Zero-Inflated
Model to Address Data Dispersion. Computational Statistics and Data
Analysis, 99, 68-80.

Galit Shmueli, Thomas P. Minka, Joseph B. Kadane, Sharad Borle, and Peter
Boatwright (2005). A useful distribution for fitting discrete data: revival
of the Conway-Maxwell-Poisson distribution. Journal of Royal Statistical
Society C, 54, 127-142.
}
\author{
Kimberly Sellers, Thomas Lotze, Andrew M. Raim
}
