% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{readMacSynergyValues}
\alias{readMacSynergyValues}
\title{Read data from macSynergyII format and clean for outliers.}
\usage{
readMacSynergyValues(file, sheet, nrow = 41, wellRangesExcel,
  minThersholdForCVCal, minThersholdForCV)
}
\arguments{
\item{file}{Name of file containing data.}

\item{sheet}{Sheet number in a spread sheet workbook.}

\item{nrow}{Number of rows in that sheet to be read.}

\item{wellRangesExcel}{TRUE if input wells ranges are in excel format.}

\item{minThersholdForCVCal}{CV threshold for data outliers.}

\item{minThersholdForCV}{Threshold of survival values not used for CV calculations.}
}
\value{
Matrix of outlier removed data replicates.
}
\description{
Read data from macSynergyII format and clean for outliers.
}
\examples{
fl <- system.file("/raw/testData.xls", package="COMBIA")
sh <- 1
wellR <- list(c( "l3:l10","m3:m10","b3:k10",  "l13:l20","m13:m20","b13:k20",
           "l23:l30","m23:m30","b23:k30",  "l33:l40","m33:m40","b33:k40"))
minThersholdForCV <- 0.3
minThersholdForCVCal <- 0.1
rslt <- readMacSynergyValues(fl, sh, nrow=41, wellR,
minThersholdForCVCal, minThersholdForCV)
}
\author{
Muhammad kashif
}

