% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{combineDataFromMultipleFiles}
\alias{combineDataFromMultipleFiles}
\title{It combines data from multiple files/experiments into a matrix.
Multiple experiments can be performed at the same or
different concentration ranges. The function can also be used if
there is only one file/experiments.}
\usage{
combineDataFromMultipleFiles(yConcentration, xConcentration, replNo, file,
  totalNumberofReplicates, siReplicates)
}
\arguments{
\item{yConcentration}{Y drug concentrations.}

\item{xConcentration}{X drug concentrations.}

\item{replNo}{Number of replicates in all files.}

\item{file}{File name/names.}

\item{totalNumberofReplicates}{Total number of replicates per files.}

\item{siReplicates}{Data.}
}
\value{
Combined data of replicate survival indices from multiple experiments.
}
\description{
It combines data from multiple files/experiments into a matrix.
Multiple experiments can be performed at the same or
different concentration ranges. The function can also be used if
there is only one file/experiments.
}
\examples{
xConc <- c(0.00,  0.20,  0.39,  0.78,  1.56,  3.12,  6.25, 12.50, 25.00, 50)
yConc <- c(128,  64,  32,  16,   8,   4,   2,   0)
rN <- 4
fN <- 1
trN <- 4
dataFile <- system.file("/raw/rawDataPreProcessed.csv", package="COMBIA")
dataSample <- read.csv(dataFile, header=FALSE )
replList <- list(vector, 4)
for( i in 1:4)
{ replList[[i]] <- dataSample[i,] }
rslt <- combineDataFromMultipleFiles(list(yConc),
list(xConc), rN,fN,trN, replList )
}
\author{
Muhammad kashif
}

