% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAnnotationMatrix.R
\name{getAnnotationMatrix}
\alias{getAnnotationMatrix}
\title{Get the genes in the genomic ranges indicated by the row and column labels.}
\usage{
getAnnotationMatrix(
  genomic_matrix,
  prot_only = T,
  sequential = F,
  flip_row_col = F
)
}
\arguments{
\item{genomic_matrix}{A matrix with row and column names of the format chr1_100_200 (chr,start,end)}

\item{prot_only}{Inlcude only the protein coding genes from ensembl?}

\item{sequential}{Turn off parallelism with doParallel?}

\item{flip_row_col}{Give column genes along the rows and row genes down columns?}
}
\value{
concatenated_gene_matrix A matrix with row and column genes
}
\description{
Gets the genes in the ranges within each cell of the matrix.
}
\examples{
load(system.file("extdata","nbl_result_matrix_sign_small.rda",package = "CNVScope")) 
load(system.file("extdata","ensembl_gene_tx_table_prot.rda",package = "CNVScope"))
load(system.file("extdata","grch37.rda",package = "CNVScope"))
getAnnotationMatrix(genomic_matrix=nbl_result_matrix_sign_small[1:5,1:5],sequential=TRUE,
prot_only=TRUE)
}
\keyword{genomic}
\keyword{matrix}
