% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ggomnbd_expectation}
\alias{ggomnbd_expectation}
\alias{ggomnbd_nocov_expectation}
\alias{ggomnbd_staticcov_expectation}
\title{GGompertz/NBD: Unconditional Expectation}
\usage{
ggomnbd_nocov_expectation(r, alpha_0, b, s, beta_0, vT_i)

ggomnbd_staticcov_expectation(
  r,
  alpha_0,
  b,
  s,
  beta_0,
  vT_i,
  vCovParams_trans,
  vCovParams_life,
  mCov_life,
  mCov_trans
)
}
\arguments{
\item{r}{shape parameter of the Gamma distribution of the purchase process.
The smaller r, the stronger the heterogeneity of the purchase process.}

\item{alpha_0}{scale parameter of the Gamma distribution of the purchase process.}

\item{b}{scale parameter of the Gompertz distribution (constant across customers)}

\item{s}{shape parameter of the Gamma distribution for the lifetime process
The smaller s, the stronger the heterogeneity of customer lifetimes.}

\item{beta_0}{scale parameter for the Gamma distribution for the lifetime process}

\item{vT_i}{Number of periods since the customer came alive}

\item{vCovParams_trans}{Vector of estimated parameters for the transaction covariates.}

\item{vCovParams_life}{Vector of estimated parameters for the lifetime covariates.}

\item{mCov_life}{Matrix containing the covariates data affecting the lifetime process. One column for each covariate.}

\item{mCov_trans}{Matrix containing the covariates data affecting the transaction process. One column for each covariate.}
}
\description{
Computes the expected number of repeat transactions in the interval (0, vT_i]
for a randomly selected customer, where 0 is defined as the point when the customer came alive.
}
\details{
\code{mCov_trans} is a matrix containing the covariates data of
the time-invariant covariates that affect the transaction process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vCovParams_trans} at the respective position.

\code{mCov_life} is a matrix containing the covariates data of
the time-invariant covariates that affect the lifetime process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vCovParams_life} at the respective position.
}
\references{
Bemmaor AC, Glady N (2012). \dQuote{Modeling Purchasing Behavior with Sudden \dQuote{Death}: A Flexible Customer
Lifetime Model} Management Science, 58(5), 1012-1021.
}
