% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_interface_lrtest.R
\name{lrtest}
\alias{lrtest}
\alias{lrtest.clv.fitted}
\alias{lrtest,clv.fitted-method}
\title{Likelihood Ratio Test of Nested Models}
\usage{
\method{lrtest}{clv.fitted}(object, ..., name = NULL)

lrtest(object, ...)

\S4method{lrtest}{clv.fitted}(object, ..., name = NULL)
}
\arguments{
\item{object}{An fitted model object inheriting from \code{clv.fitted}.}

\item{...}{Other models objects fitted on the same transaction data}

\item{name}{A character vector of names to use for the models in the resulting output.
If given, a name has to be provided for \code{object} and each model in \code{...}.
If not given, the default model names are used.}
}
\value{
A \code{data.frame} of class "anova" which contains the log-likelihood,
degrees of freedom, the difference in degrees of freedom, likelihood ratio
Chi-squared statistic and corresponding p-value.
}
\description{
\code{lrtest} carrys out likelihood ratio tests to compare nested CLV models.

The method consecutively compares the first model given in \code{object} with all the
other models passed in \code{...}. An asymptotic likelihood ratio test is carried out:
Twice the difference in log-likelihoods is compared with a Chi-squared distribution.
}
